% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels-single.R
\name{lbl_manual}
\alias{lbl_manual}
\title{Defunct: label chopped intervals in a user-defined sequence}
\usage{
lbl_manual(sequence, fmt = "\%s")
}
\arguments{
\item{sequence}{A character vector of labels.}

\item{fmt}{String, list or function. A format for break endpoints.}
}
\value{
A function that creates a vector of labels.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}}
}
\details{
\code{lbl_manual()} is defunct since santoku 1.0.0. It is little used and is not
closely related to the rest of the package. It also risks mislabelling
intervals, e.g. if intervals are extended. Use of \code{lbl_manual()} will give
an error.
}
\section{Formatting endpoints}{


If \code{fmt} is not \code{NULL} then it is used to format the endpoints.
\itemize{
\item If \code{fmt} is a string, then numeric endpoints will be formatted by
\code{sprintf(fmt, breaks)}; other endpoints, e.g. \link{Date} objects, will be
formatted by \code{format(breaks, fmt)}.
\item If \code{fmt} is a list, then it will be used as arguments to \link{format}.
\item If \code{fmt} is a function, it should take a vector of numbers (or other objects
that can be used as breaks) and return a character vector. It may be helpful
to use functions from the \code{{scales}} package, e.g. \code{\link[scales:label_number]{scales::label_comma()}}.
}
}

\examples{
\dontrun{
chop(1:10, c(2, 5, 8), lbl_manual(c("w", "x", "y", "z")))
# ->
chop(1:10, c(2, 5, 8), labels = c("w", "x", "y", "z"))
}
}
\seealso{
Other labelling functions: 
\code{\link{lbl_dash}()},
\code{\link{lbl_discrete}()},
\code{\link{lbl_endpoints}()},
\code{\link{lbl_glue}()},
\code{\link{lbl_intervals}()},
\code{\link{lbl_midpoints}()},
\code{\link{lbl_seq}()}
}
\concept{labelling functions}
\keyword{internal}
