% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Generate Example Data}
\usage{
generate_data(n, cens, haz_ae, haz_death, haz_soft)
}
\arguments{
\item{n}{(\code{count})\cr number of patients.}

\item{cens}{(\code{numeric})\cr minimum and maximum censoring time.}

\item{haz_ae}{(\code{number})\cr constant hazard for AE.}

\item{haz_death}{(\code{number})\cr constant hazard for death.}

\item{haz_soft}{(\code{number})\cr constant hazard for soft competing event.}
}
\value{
(\code{data.frame})\cr a \code{data.frame} with the following columns:
\itemize{
\item \code{id}: Patient ID.
\item \code{time_to_event}: Time to the first AE, death or soft competing event.
\item \code{type_of_event}: 0 for censored, 1 for AE, 2 for death, 3 for soft
competing event.
\item \code{cens}: Censoring time.
}
}
\description{
This generates the dataset denoted by \code{S1} in Table 4 of
\insertCite{stegherr_estimating_2021;textual}{savvyr},
i.e. we assume constant hazards for the adverse event (AE) hazard, the
hazard for the competing event of death, and the hazard for the "soft"
competing events. Censoring is uniform in the given range.
}
\examples{
set.seed(123)
generate_data(n = 5, cens = c(2, 5), haz_ae = 2, haz_death = 3, haz_soft = 5)
}
\references{
\insertRef{stegherr_estimating_2021}{savvyr}
}
