% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_rm.R
\name{item_rm_recursive}
\alias{item_rm_recursive}
\title{Remove an item completely by recursively removing its child items}
\usage{
item_rm_recursive(sb_id, ..., limit = 1000)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}.}
}
\value{
\code{TRUE} to indicate success
}
\description{
BEWARE: This completely removes ALL CHILD ITEMS AND THEIR CHILDREN
  as well as the item itself.
}
\examples{
\dontrun{
# Create an item with nested structure
authenticate_sb()
fname <- "chairs"
folder = folder_create(user_id(), name = fname)
item_create(folder, title='child1')
item_create(folder, title='child2')

item_list_children(folder)

# then delete the whole folder
sbtools:::item_rm_recursive(folder)
}
}
\keyword{internal}
