% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_create.R
\name{item_create}
\alias{item_create}
\title{Create a new SB item}
\usage{
item_create(parent_id = user_id(), title, ..., info)
}
\arguments{
\item{parent_id}{An \code{\link{sbitem}} object or character ScienceBase ID corresponding to the 
parent item (folder)}

\item{title}{The title of the new SB item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}}

\item{info}{(optional) list of metadata info for the new item}
}
\value{
An object of class \code{sbitem}
}
\description{
Create a new item on ScienceBase with the requested parent and item title. 
Info can be provided to populate metadata at the time of creation.
}
\examples{
\dontrun{
# Create an item - by default we use your user ID
item_create(title = "testing 123")

# Pass an object of class sbitem
x <- folder_create(user_id(), "foobar456")
item_create(x, "foobar456-item")
}
}
