% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CombinePvalues.R
\name{CombinePvalues}
\alias{CombinePvalues}
\title{Combine p-values across multiple samples from scBSP}
\usage{
CombinePvalues(list_of_pvalues, method = c("fisher", "stouffer"))
}
\arguments{
\item{list_of_pvalues}{A list of data.frames, each with columns:
\code{GeneNames}, \code{P_values}.}

\item{method}{Combination method. One of \code{"fisher"} (default) or
\code{"stouffer"}.}
}
\value{
A data.frame with columns:
  \itemize{
    \item GeneNames
    \item Number_Samples: number of datasets contributing to this gene
    \item Calibrated_P_values: the combined p-value
  }
}
\description{
Given the results from multiple samples with gene names and p-values, this 
function merges them by gene and computes a combined p-value for each gene. 
Fisher's method or Stouffer's method can be used.
}
\examples{
df1 <- data.frame(GeneNames = c("A","B","C"),
                  P_values = c(0.01, 0.20, 0.03))
df2 <- data.frame(GeneNames = c("A","C","D"),
                  P_values = c(0.04, 0.10, 0.50))
df3 <- data.frame(GeneNames = c("B","C","E"),
                  P_values = c(0.05, 0.02, 0.80))

CombinePvalues(list(df1, df2, df3), method = "fisher")

}
