% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Write_Data.R
\name{Read10X_GEO}
\alias{Read10X_GEO}
\title{Load in NCBI GEO data from 10X}
\usage{
Read10X_GEO(
  data_dir = NULL,
  sample_list = NULL,
  sample_names = NULL,
  gene.column = 2,
  cell.column = 1,
  unique.features = TRUE,
  strip.suffix = FALSE,
  parallel = FALSE,
  num_cores = NULL,
  merge = FALSE
)
}
\arguments{
\item{data_dir}{Directory containing the matrix.mtx, genes.tsv (or features.tsv), and barcodes.tsv
files provided by 10X.}

\item{sample_list}{A vector of file prefixes/names if specific samples are desired.  Default is \code{NULL} and
will load all samples in given directory.}

\item{sample_names}{a set of sample names to use for each sample entry in returned list.  If \code{NULL} will
set names to the file name of each sample.}

\item{gene.column}{Specify which column of genes.tsv or features.tsv to use for gene names; default is 2.}

\item{cell.column}{Specify which column of barcodes.tsv to use for cell names; default is 1.}

\item{unique.features}{Make feature names unique (default TRUE).}

\item{strip.suffix}{Remove trailing "-1" if present in all cell barcodes.}

\item{parallel}{logical (default FALSE).  Whether to use multiple cores when reading in data.
Only possible on Linux based systems.}

\item{num_cores}{if \code{parallel = TRUE} indicates the number of cores to use for multi-core processing.}

\item{merge}{logical (default FALSE) whether or not to merge samples into a single matrix or return
list of matrices.  If TRUE each sample entry in list will have cell barcode prefix added.  The prefix
will be taken from \code{sample_names}.}
}
\value{
If features.csv indicates the data has multiple data types, a list
containing a sparse matrix of the data from each type will be returned.
Otherwise a sparse matrix containing the expression data will be returned.
}
\description{
Enables easy loading of sparse data matrices provided by 10X genomics. That have file prefixes
added to them by NCBI GEO or other repos.
}
\examples{
\dontrun{
data_dir <- 'path/to/data/directory'
expression_matrices <- Read10X_GEO(data_dir = data_dir)
# To create object from single file
seurat_object = CreateSeuratObject(counts = expression_matrices[[1]])
}

}
\references{
Code used in function has been slightly modified from \code{Seurat::Read10X} function of
Seurat package \url{https://github.com/satijalab/seurat} (License: GPL-3).  Function was modified to
support file prefixes and altered loop by Samuel Marsh for scCustomize (also previously posted as
potential PR to Seurat GitHub).
}
\concept{read_&_write}
