% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.scdf.R
\name{as.data.frame.scdf}
\alias{as.data.frame.scdf}
\title{Creating a long format data frame from several single-case data frames
(scdf).}
\usage{
\method{as.data.frame}{scdf}(x, ..., l2 = NULL, id = "case")
}
\arguments{
\item{x}{An scdf object}

\item{...}{Not implemented}

\item{l2}{A data frame providing additional variables at Level 2. The scdf
has to have names for all cases and the Level 2 data frame has to have a
column with corresponding case names.}

\item{id}{Variable name of the Level 2 data frame that contains the case
names.}
}
\value{
Returns one data frame with data of all single-cases structured by
the case variable.
}
\description{
The as.data.frame function transposes an scdf into one long data frame.
Additionally, a data frame can be merged that includes level 2 data of the
subjects. This might be helpful to prepare data to be used with other
packages than scan.
}
\examples{

## Convert the list of three single-case data frames from Grosche (2011)
### into one long data frame
Grosche2011
Grosche2011_long <- as.data.frame(Grosche2011)
Grosche2011_long

## Combine an scdf with data for l2
Leidig2018_long <- as.data.frame(Leidig2018, l2 = Leidig2018_l2)
names(Leidig2018_long)
summary(Leidig2018_long)

}
\seealso{
Other data manipulation functions: 
\code{\link{add_l2}()},
\code{\link{as_scdf}()},
\code{\link{fill_missing}()},
\code{\link{moving_median}()},
\code{\link{print.sc_outlier}()},
\code{\link{ranks}()},
\code{\link{rescale}()},
\code{\link{scdf}()},
\code{\link{select_cases}()},
\code{\link{set_vars}()},
\code{\link{shift}()},
\code{\link{smooth_cases}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{manip}
