% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action-cookie.R
\name{req_has_cookie}
\alias{req_has_cookie}
\title{Switch Scenes on Cookies}
\usage{
req_has_cookie(cookie_name, validation_fn = NULL, ..., negate = FALSE)
}
\arguments{
\item{cookie_name}{The cookie that must be present, as a length-1 character
vector.}

\item{validation_fn}{A function that takes the value of the cookie as the
first parameter, and returns \code{TRUE} if the cookie is valid, and \code{FALSE}
otherwise.}

\item{...}{Additional parameters passed on to \code{validation_fn}.}

\item{negate}{If \code{TRUE}, trigger the corresponding scene when this action is
\code{not} matched.}
}
\value{
A \code{scene_action} object, to be used in \code{\link[=set_scene]{set_scene()}}.
}
\description{
Create a \code{scene_action} specifying a cookie that must be present (or absent)
and optionally a check function for that cookie.
}
\examples{
# Specify an action to detect a cookie named "mycookie".
req_has_cookie("mycookie")

# Specify an action to detect the *lack* of a cookie named "mycookie".
req_has_cookie("mycookie", negate = TRUE)

# Specify an action to detect a cookie named "mycookie" that has 27
# characters.
req_has_cookie(
  cookie_name = "mycookie",
  validation_fn = function(cookie_value) {
    nchar(cookie_value == 27)
  }
)

# Specify an action to detect a cookie named "mycookie" that has N
# characters. This would make more sense in a case where validation_fn isn't
# an anonymous function.
req_has_cookie(
  cookie_name = "mycookie",
  validation_fn = function(cookie_value, N) {
    nchar(cookie_value) == N
  },
  N = 27
)
}
