% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{xyz_to_rgb}
\alias{xyz_to_rgb}
\title{Convert from RGB colour channels to XYZ space.}
\usage{
xyz_to_rgb(xyz, transformation = "sRGB", linear_func = NULL)
}
\arguments{
\item{xyz}{A dataframe or matrix with X, Y and Z colour channels located in the columns 1 to 3, respectively.}

\item{transformation}{An option in \code{c("sRGB", "Adobe")} for a built-in transformation or, alternatively, a custom 3x3 transformation matrix.}

\item{linear_func}{A function to convert linear RGB colour space into RGB space. Used only if a custom transformation matrix is provided. Transformation skips if no function is provided under a user-defined transformation matrix. See: https://en.wikipedia.org/wiki/SRGB.}
}
\value{
A \code{tibble} of red, green and blue colour channels.
}
\description{
Convert from RGB colour channels to XYZ space.
}
\examples{
x <- sample(x = 40:60, size = 10, replace = TRUE)
y <- sample(x = 40:60, size = 10, replace = TRUE)
z <- sample(x = 40:60, size = 10, replace = TRUE)
xyz_to_rgb(data.frame(x = x, y = y, z = z))
}
