% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{club_cat_class}
\alias{club_cat_class}
\title{Clubbing class of a categorical variable with low population percentage with another class of similar event rate}
\usage{
club_cat_class(base, target, variable, threshold, event = 1)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{variable}{column name of categorical variable on which the operation is to be done, to be passed as string}

\item{threshold}{threshold population percentage below which the class will be considered to be be clubbed with another class, to be provided as decimal/fraction}

\item{event}{(optional) the event class, to be passed as 0 or 1 (default is 1)}
}
\value{
The function returns a dataframe after clubbing low percentage classes with another class of similar or closest but higher event rate.
}
\description{
The function groups classes of categorical variable, which have population percentage less than a threshold, with another class of similar event rate. If a class of exactly same event rate is not available, it is clubbed with the one having a higher event rate closest to it.
}
\examples{
data <- iris[1:110,]
data$Species <- as.character(data$Species)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
data_clubclass <- club_cat_class(base = data,target = "Y",variable = "Species",threshold = 0.2)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>

Kanishk Dogar <kanishkd4@gmail.com>
}
