% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cv_table}
\alias{cv_table}
\title{Pairwise Cramer's V among a list of categorical variables}
\usage{
cv_table(base, column_name)
}
\arguments{
\item{base}{input dataframe}

\item{column_name}{column name or array of column names for which Cramer's V is to be calculated}
}
\value{
An object of class "cv_table" is a list containing the following components:

\item{cv_val_tab}{pairwise Cramer's V value as a dataframe}

\item{single_class_var_index}{array of column index of variables with only one class}
}
\description{
The function gives a dataframe with pairwise Cramer's V value between all possible combination of categorical variables from the list of variables provided.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
data$Sepal.Length <- as.character(floor(data$Sepal.Length))
cv_tab_list <- cv_table(data, c("Species", "Sepal.Length"))
cv_tab_list$cv_val_tab
cv_tab_list$single_class_var_index
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
