% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fixdynamic}
\alias{fixdynamic}
\title{Fix Dynamic Parameters of a Tape}
\usage{
fixdynamic(pfun, theta, isfixed)
}
\arguments{
\item{pfun}{An \code{Rcpp_ADFun} object.}

\item{theta}{A numerical vector specifying the value of all dynamic parameters of \code{pfun}. Some of these will be fixed according to \code{isfixed}, the remainder will remain dynamic.}

\item{isfixed}{A boolean vector same length as \code{theta}. \code{TRUE} values are fixed at the value of \code{theta}, \code{FALSE} values are left dynamic.}
}
\value{
An \code{Rcpp_ADFun} object.
}
\description{
Retapes an existing \code{CppAD} tape but with some of original dynamic parameters fixed to specified values.
For creating this tape, the values of \code{pfun$xtape} is used.
}
\seealso{
Other tape builders: 
\code{\link{avgrange}()},
\code{\link{fixindependent}()},
\code{\link{keeprange}()},
\code{\link{tape_Hessian}()},
\code{\link{tape_Jacobian}()},
\code{\link{tape_bdryw}()},
\code{\link{tape_gradoffset}()},
\code{\link{tape_logJacdet}()},
\code{\link{tape_smd}()},
\code{\link{tape_swap}()},
\code{\link{tape_uld}()}
}
\concept{tape builders}
