% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LouvainDepart.R
\name{LouvainDepart}
\alias{LouvainDepart}
\alias{LouvainDepart.scppp}
\alias{LouvainDepart.matrix}
\title{Louvain clustering using departure as data representation}
\usage{
LouvainDepart(
  data,
  pdat = NULL,
  PCA = TRUE,
  N = 15,
  pres = 0.8,
  tsne = FALSE,
  umap = FALSE,
  ...
)

\method{LouvainDepart}{scppp}(
  data,
  pdat = NULL,
  PCA = TRUE,
  N = 15,
  pres = 0.8,
  tsne = FALSE,
  umap = FALSE,
  ...
)

\method{LouvainDepart}{matrix}(
  data,
  pdat = NULL,
  PCA = TRUE,
  N = 15,
  pres = 0.8,
  tsne = FALSE,
  umap = FALSE,
  ...
)
}
\arguments{
\item{data}{A UMI count matrix with genes as rows and cells as columns, or an S3 object of class 'scppp'.}

\item{pdat}{A matrix used as input for cell clustering. If not specified, the departure matrix will be calculated within the function.}

\item{PCA}{A logical value specifying whether to apply PCA before Louvain clustering. Default is \code{TRUE}.}

\item{N}{A numeric value specifying the number of principal components included for further clustering (default 15).}

\item{pres}{A numeric value specifying the resolution parameter in Louvain clustering (default 0.8).}

\item{tsne}{A logical value specifying whether t-SNE dimension reduction should be applied for visualization.}

\item{umap}{A logical value specifying whether UMAP dimension reduction should be applied for visualization.}

\item{...}{Not used.}
}
\value{
A list with the following elements:
\describe{
  \item{\code{sdata}}{A Seurat object}
  \item{\code{tsne_data}}{A matrix containing t-SNE dimension reduction results,
        with cells as rows and first two t-SNE dimensions as columns; NULL if \code{tsne = FALSE}}
  \item{\code{umap_data}}{A matrix containing UMAP dimension reduction results,
        with cells as rows and first two UMAP dimensions as columns; NULL if \code{umap = FALSE}}
  \item{\code{res_clust}}{A data frame containing two columns: names (cell names) and clusters (cluster labels)}
}
}
\description{
This function returns a list with elements useful to check and compare cell clustering.
}
\details{
This is a function used to get cell clustering using Louvain clustering algorithm implemented in the Seurat package.
}
\examples{

set.seed(1234)
test_set <- matrix(rpois(500, 2), nrow = 20)
rownames(test_set) <- paste0("gene", 1:nrow(test_set))
colnames(test_set) <- paste0("cell", 1:ncol(test_set))
LouvainDepart(test_set)

}
\references{
\insertRef{Seurat}{scpoisson}
}
