% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_u.R
\name{sigma_u}
\alias{sigma_u}
\title{The tuning parameter for the estimation of the time series central mean subspace}
\usage{
sigma_u(y, p, d, w1_list=seq(0.1,0.5,by=0.1),space="mean",
                                 std=FALSE,density="kernel",method="FM",B=20)
}
\arguments{
\item{y}{A univariate time series observations.}

\item{p}{Integer value. The lag of the time series.}

\item{d}{Integer value. The dimension of the time series central mean subspace.}

\item{w1_list}{(default \{0.1, 0.2,0.3,0.4,0.5\}). The sequence of candidate list for the tuning parameter.}

\item{space}{(default ``mean''). Specify the SDR subspace needed to be estimated.}

\item{std}{(default FALSE). If TRUE, then standardizing the time series observations.}

\item{density}{(default ``kernel''). Specify the density function for the estimation (``kernel'' or ``normal'').}

\item{method}{(default ``FM''). Specify the estimation method. (``FM'' or ``NW'').}

\item{B}{(default 20). Number of block bootstrap samples.}
}
\value{
The output is a length(sw2_seq) dimensional vector.
\item{dis_sw2}{The average block boostrap distances for each candidate list of values.}
}
\description{
`sigma_u()' estimates the turning parameter needed to estimate time series central mean subspace in Fourier Method.
}
\examples{
\donttest{
data("lynx")
y <- log10(lynx)
p <- 3
d <- 1
w1_list=seq(0.1,0.5,by=0.1)
Tuning.model=sigma_u(y, p, d, w1_list=w1_list, std=FALSE, B=10)
Tuning.model$sigma_u_hat
}
}
\references{
Samadi S. Y. and De Alwis T. P. (2023). Fourier Method of Estimating Time Series Central Mean Subspace.
\emph{https://arxiv.org/pdf/2312.02110}.
}
