% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tbl_xyz2mat}
\alias{tbl_xyz2mat}
\title{convert xyz tbl to matrix}
\usage{
tbl_xyz2mat(tbl, x = 1, y = 2, z = 3)
}
\arguments{
\item{tbl}{A \code{tibble},\code{data.frame} or \code{sf} object.}

\item{x}{(optional) The x-axis coordinates column number, default is \code{1}.}

\item{y}{(optional) The y-axis coordinates column number, default is \code{2}.}

\item{z}{(optional) The z (attribute) coordinates column number, default is \code{3}.}
}
\value{
A \code{list}.
\describe{
\item{z_attrs_matrix}{A matrix with attribute information.}
\item{x_coords_matrix}{A matrix with the x-axis coordinates.}
\item{y_coords_matrix}{A matrix with the y-axis coordinates.}
}
}
\description{
convert xyz tbl to matrix
}
\examples{
set.seed(42)
lon = rep(1:3,each = 3)
lat = rep(1:3,times = 3)
zattr = rnorm(9, mean = 10, sd = 1)
demodf = data.frame(x = lon, y = lat, z = zattr)
demodf
tbl_xyz2mat(demodf)

}
