% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code-to-term.R
\name{code_to_term}
\alias{code_to_term}
\title{SDTM code to term}
\usage{
code_to_term(code, clst_code)
}
\arguments{
\item{code}{A C-code with a leading character C followed by a sequence of
digits used for uniquely identifying each concept in NCI Thesaurus (NCIt),
including all CDISC concepts.}

\item{clst_code}{Parent codelist code.}
}
\value{
A character vector of SDTM controlled terminology terms. The number
of elements returned matches the number of elements in \code{code}, i.e. there
is a one-to-one correspondence between input and output. Invalid codes in
\code{code} are mapped to \code{NA}.
}
\description{
\code{\link[=code_to_term]{code_to_term()}} maps SDTM terminology C-codes to respective terms. For
mapping codes representing codelists, use \code{\link[=clst_code_to_term]{clst_code_to_term()}} instead.
}
\examples{
code_to_term(code = "C174106", clst_code = "C141657")

# Both `code` and `clst_code` are vectorized. `clst_code` will be recycled
# to match `code` number of elements.
code_to_term(code = c("C174106", "C141700"), clst_code = "C141657")

# You may mix codelists as long as `code` and `clst_code` have the same
# number of elements; they will be matched element-wise.
code_to_term(
  code = c("C174106", "C141700", "C141701"),
  clst_code = c("C141657", "C141657", "C141656")
)

# Invalid codes (e.g. `"C00000"`) map to `NA`.
code_to_term(code = c("C174106", "C141700", "C00000"), clst_code = "C141657")

}
\seealso{
See \code{\link[=term_to_code]{term_to_code()}} for the inverse operation.
}
