% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tu_tudtc.R
\name{check_tu_tudtc}
\alias{check_tu_tudtc}
\title{Check for missing TUDTC values}
\usage{
check_tu_tudtc(TU, preproc = identity, ...)
}
\arguments{
\item{TU}{Tumor Identification SDTM dataset with variables USUBJID, TUDTC,
VISIT, TUORRES, TUSPID (optional), TUTESTCD (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing TUDTC values and returns a data frame.
Only applies to assessments by investigator.
}
\examples{
TU <- data.frame(
USUBJID = "1001",
TUDTC = "2020-05-05",
VISIT = "C1D1",
TUORRES = 1:10,
TUSPID = "FORMNAME-R:19/L:19XXXX",
TUEVAL = "INVESTIGATOR",
TUTESTCD = "TUMIDENT",
stringsAsFactors = FALSE
)

TU$TUDTC[1]=""
TU$TUDTC[2]="NA"
TU$TUDTC[3]=NA

check_tu_tudtc(TU,preproc=roche_derive_rave_row)

TU$TUEVAL[1]=""
TU$TUTESTCD=NULL
check_tu_tudtc(TU,preproc=roche_derive_rave_row)

TU$TUEVAL[2]="INDEPENDENT ASSESSOR"
TU$TUEVAL[3]="INDEPENDENT ASSESSOR"
TU$TUDTC[4]=""
check_tu_tudtc(TU)

TU$TUSPID=NULL
check_tu_tudtc(TU)

TU$VISIT=NULL
check_tu_tudtc(TU)


}
\author{
Beeya Na
}
