% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{report_to_xlsx}
\alias{report_to_xlsx}
\title{Save report as an xlsx file}
\usage{
report_to_xlsx(res, outfile, extrastring = "")
}
\arguments{
\item{res}{results list created by run_all_checks}

\item{outfile}{file path/name to write to}

\item{extrastring}{optionally display extra info alongside version info, e.g. diff info}
}
\value{
xlsx file
}
\description{
Save report as an xlsx file
}
\examples{

# Create Dummy data

ae = data.frame(
 USUBJID = 1:5,
 DOMAIN = c(rep("AE", 5)),
 AESEQ = 1:5,
 AESTDTC = 1:5,
 AETERM = 1:5,
 AEDECOD = 1:5,
  AESPID = c("FORMNAME-R:13/L:13XXXX",
             "FORMNAME-R:16/L:16XXXX",
             "FORMNAME-R:2/L:2XXXX",
             "FORMNAME-R:19/L:19XXXX",
             "FORMNAME-R:5/L:5XXXX"),
 stringsAsFactors = FALSE
)

cm = data.frame(
 USUBJID = 1:5,
 DOMAIN = rep("CM", 5),
 CMTRT = rep("DRUG TERM", 5),
 CMDECOD = rep("CODED DRUG TERM", 5),
 CMSTDTC = 1:5,
 CMENDTC = 1:5,
 CMCAT = "CONCOMITANT MEDICATIONS",
 CMSPID = c("FORMNAME-R:13/L:13XXXX",
             "FORMNAME-R:16/L:16XXXX",
             "FORMNAME-R:2/L:2XXXX",
             "FORMNAME-R:19/L:19XXXX",
             "FORMNAME-R:5/L:5XXXX"),
 stringsAsFactors=FALSE
)

res=run_all_checks(verbose = FALSE)
fileName <- file.path(tempdir(), "check_results.xlsx")
report_to_xlsx(res=res,outfile=fileName)

}
\seealso{
Example programs for running data checks
\code{\link{diff_reports}()},
\code{\link{run_all_checks}()},
\code{\link{run_check}()}
}
\concept{ex_rpt}
\keyword{ex_rpt}
\keyword{internal}
