% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ds_dsdecod_death.R
\name{check_ds_dsdecod_death}
\alias{check_ds_dsdecod_death}
\title{Check for study discontinuation record if death indicated}
\usage{
check_ds_dsdecod_death(DS, preproc = identity, ...)
}
\arguments{
\item{DS}{Disposition domain with variables USUBJID, DSDECOD, DSSCAT, and
optional variables DSCAT, DSSTDTC, DSSPID}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
If a patient has a record where DS.DSDECOD == DEATH they should
also have a Study Discon Record
}
\examples{

DS <- data.frame(
 STUDYID = 1,
 USUBJID = 1:3,
 DSDECOD = c(NA,"DEATH",NA),
 DSSTDTC = c(NA,"DSDATE",NA),
 DSCAT = c('DISPOSITION EVENT', 'DISPOSITION EVENT', 'OTHER'),
 DSSCAT = c('STUDY COMPLETION/EARLY DISCONTINUATION',
            'TREATMENT DISCONTINUATION',
            'STUDY TREATMENT'),
 DSOTH = 1:3,
 DSSPID = "XXX-R:0",
 stringsAsFactors=FALSE
 )

check_ds_dsdecod_death(DS)
check_ds_dsdecod_death(DS,preproc=roche_derive_rave_row)

DS$DSSCAT[2] <- "STUDY COMPLETION/EARLY DISCONTINUATION"
check_ds_dsdecod_death(DS)

DS$DSDECOD = NULL
check_ds_dsdecod_death(DS)


}
\author{
Sara Bodach and Will Harris
}
