% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_extrt_exoccur.R
\name{check_ex_extrt_exoccur}
\alias{check_ex_extrt_exoccur}
\title{Check for EX records where EXTRT is missing}
\usage{
check_ex_extrt_exoccur(EX)
}
\arguments{
\item{EX}{Exposure domain with variables USUBJID, EXSTDTC, EXTRT, EXDOSE}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check looks for EX records where EXTRT is missing but EXOCCUR=Y (or EXOCCUR doesn't exist) and returns a data frame
}
\examples{

EX <- data.frame(
USUBJID = 1:10,
EXTRT = 1:10,
EXOCCUR = c(rep("Y",5), rep("",5)),
EXSTDTC = "2016-01-01",
EXDOSE = 1:10,
stringsAsFactors=FALSE
)

EX$EXTRT[1]=""
EX$EXTRT[2]="NA"
EX$EXTRT[3]=NA
EX$EXTRT[6]=""
EX$EXTRT[7]="NA"
EX$EXTRT[8]=NA

check_ex_extrt_exoccur(EX)

EX$EXOCCUR=NULL

check_ex_extrt_exoccur(EX)


}
\author{
Betty Wang
}
