% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{create_STAT}
\alias{create_STAT}
\title{Assign STAT 'NOT DONE' status}
\usage{
create_STAT(
  df,
  domain,
  nd_ind,
  nd_ind_cd = "Yes",
  USUBJID = "USUBJID",
  VISIT = "VISIT"
)
}
\arguments{
\item{df}{a data frame to modify}

\item{domain}{a string, the domain abbreviation in all caps}

\item{nd_ind}{a string, the variable name in \code{df} that indicates if a test
was not performed, usually a \code{"Yes"}/\code{"No"} or \code{"Y"}/\code{"N"} column}

\item{nd_ind_cd}{a string, the code from the \code{nd_ind} column that signifies
a test was not done, default is \code{"Yes"}}

\item{USUBJID}{a string, the variable name in \code{df} that contains the subject
identifier, default is \code{"USUBJID"}}

\item{VISIT}{a string, the variable name in \code{df} that indicates a VISIT field,
default is \code{"VISIT"}}
}
\value{
a modified copy of \code{df}
}
\description{
Creates a --STAT variable and, if all measurements for a visit were not done,
also changes all --TESTCD values as "--ALL"
}
\examples{
df <- dplyr::tibble(
  USUBJID = paste("Subject", c(rep("A", 2), rep("B", 4), rep("C", 2))),
  VISIT = paste("Visit", c(1  , 2  , 1  , 1  , 2  , 2  , 2  , 2)),
  XXTESTCD = paste("Test", c(1  , 2  , 1  , 2  , 1  , 2  , 1  , 2)),
  ND = c("N", "N", "Y", "Y", "N", "N", "Y", "Y")
)
create_STAT(df = df, domain = "XX", nd_ind = "ND", nd_ind_cd = "Y")

}
