% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation-framework.R
\name{BenchmarkValidator}
\alias{BenchmarkValidator}
\title{Benchmark Validation System}
\description{
A comprehensive validation framework for testing search strategies against
established benchmark datasets across multiple domains.
}
\details{
The BenchmarkValidator class provides tools for:
\itemize{
\item Cross-domain validation across medical, environmental, social science domains
\item Sensitivity analysis for search parameters
\item Statistical comparison of strategy performance
\item Reproducible benchmark testing
}
}
\section{Fields}{

\describe{
\item{\code{benchmarks}}{List of benchmark datasets with known relevant articles}
}
}

\section{Methods}{

\describe{
\item{\code{new()}}{Initialize a new BenchmarkValidator instance}
\item{\code{validate_strategy(search_strategy, benchmark_name)}}{Validate against specific benchmark}
\item{\code{cross_domain_validation(search_strategy)}}{Test across multiple domains}
\item{\code{sensitivity_analysis(base_strategy, parameter_ranges)}}{Parameter sensitivity testing}
}
}

\examples{
# Create validator
validator <- BenchmarkValidator$new()

# Check available benchmarks
print(names(validator$benchmarks))

# Define search strategy
strategy <- list(
  terms = c("systematic review", "meta-analysis"),
  databases = c("PubMed", "Embase")
)

# Create sample data for validation
sample_data <- data.frame(
  id = paste0("art", 1:20),
  title = paste("Article", 1:20),
  abstract = paste("Abstract", 1:20),
  source = "Journal",
  date = Sys.Date()
)

# Add custom benchmark
validator$add_benchmark("custom", sample_data, paste0("art", 1:5))

# Validate against custom benchmark
results <- validator$validate_strategy(strategy, "custom")

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{benchmarks}}{List of benchmark datasets}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BenchmarkValidator-new}{\code{BenchmarkValidator$new()}}
\item \href{#method-BenchmarkValidator-add_benchmark}{\code{BenchmarkValidator$add_benchmark()}}
\item \href{#method-BenchmarkValidator-validate_strategy}{\code{BenchmarkValidator$validate_strategy()}}
\item \href{#method-BenchmarkValidator-validate_single_benchmark}{\code{BenchmarkValidator$validate_single_benchmark()}}
\item \href{#method-BenchmarkValidator-cross_domain_validation}{\code{BenchmarkValidator$cross_domain_validation()}}
\item \href{#method-BenchmarkValidator-sensitivity_analysis}{\code{BenchmarkValidator$sensitivity_analysis()}}
\item \href{#method-BenchmarkValidator-clone}{\code{BenchmarkValidator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BenchmarkValidator-new"></a>}}
\if{latex}{\out{\hypertarget{method-BenchmarkValidator-new}{}}}
\subsection{Method \code{new()}}{
Creates a new BenchmarkValidator instance and loads benchmark datasets.
This method is called automatically when creating a new validator with
\code{BenchmarkValidator$new()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BenchmarkValidator$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value, called for side effects (loading benchmarks)
Add a custom benchmark dataset
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BenchmarkValidator-add_benchmark"></a>}}
\if{latex}{\out{\hypertarget{method-BenchmarkValidator-add_benchmark}{}}}
\subsection{Method \code{add_benchmark()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BenchmarkValidator$add_benchmark(name, corpus, relevant_ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the benchmark}

\item{\code{corpus}}{Data frame with article corpus}

\item{\code{relevant_ids}}{Vector of relevant article IDs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, called for side effects
Validate search strategy against benchmarks
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BenchmarkValidator-validate_strategy"></a>}}
\if{latex}{\out{\hypertarget{method-BenchmarkValidator-validate_strategy}{}}}
\subsection{Method \code{validate_strategy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BenchmarkValidator$validate_strategy(search_strategy, benchmark_name = "all")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_strategy}}{Search strategy object}

\item{\code{benchmark_name}}{Name of benchmark dataset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Validation results
Validate against single benchmark (PUBLIC METHOD)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BenchmarkValidator-validate_single_benchmark"></a>}}
\if{latex}{\out{\hypertarget{method-BenchmarkValidator-validate_single_benchmark}{}}}
\subsection{Method \code{validate_single_benchmark()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BenchmarkValidator$validate_single_benchmark(search_strategy, benchmark_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_strategy}}{Search strategy object}

\item{\code{benchmark_name}}{Name of benchmark dataset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Validation results
Cross-domain validation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BenchmarkValidator-cross_domain_validation"></a>}}
\if{latex}{\out{\hypertarget{method-BenchmarkValidator-cross_domain_validation}{}}}
\subsection{Method \code{cross_domain_validation()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BenchmarkValidator$cross_domain_validation(search_strategy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_strategy}}{Search strategy object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cross-domain validation results
Sensitivity analysis for search parameters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BenchmarkValidator-sensitivity_analysis"></a>}}
\if{latex}{\out{\hypertarget{method-BenchmarkValidator-sensitivity_analysis}{}}}
\subsection{Method \code{sensitivity_analysis()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BenchmarkValidator$sensitivity_analysis(base_strategy, parameter_ranges)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_strategy}}{Base search strategy}

\item{\code{parameter_ranges}}{List of parameter ranges to test}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Sensitivity analysis results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BenchmarkValidator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BenchmarkValidator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BenchmarkValidator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
