% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance-metrics.R
\name{calc_strategy_comparison}
\alias{calc_strategy_comparison}
\title{Calculate Strategy Comparison Metrics}
\usage{
calc_strategy_comparison(strategy1_results, strategy2_results, gold_standard)
}
\arguments{
\item{strategy1_results}{Vector of article IDs from strategy 1}

\item{strategy2_results}{Vector of article IDs from strategy 2}

\item{gold_standard}{Vector of relevant article IDs}
}
\value{
List containing comparison metrics
}
\description{
Calculate Strategy Comparison Metrics
}
\details{
Compares two search strategies across multiple dimensions:
\itemize{
\item \strong{overlap_analysis}: Articles found by both, one, or neither strategy
\item \strong{performance_comparison}: Precision, recall, F1 for each strategy
\item \strong{complementarity}: How well strategies complement each other
\item \strong{efficiency_comparison}: Relative efficiency metrics
}
}
\examples{
strategy1 <- c("art1", "art2", "art3", "art4", "art5")
strategy2 <- c("art3", "art4", "art5", "art6", "art7")
gold_standard <- c("art1", "art3", "art5", "art8", "art9")

comparison <- calc_strategy_comparison(strategy1, strategy2, gold_standard)
print(comparison$overlap_analysis)
}
