% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed-connector.R
\name{search_multiple_databases}
\alias{search_multiple_databases}
\title{Search Multiple Databases}
\usage{
search_multiple_databases(
  search_strategy,
  databases = c("pubmed"),
  max_results_per_db = 100
)
}
\arguments{
\item{search_strategy}{List containing search parameters}

\item{databases}{Vector of databases to search ("pubmed", "pmc", etc.)}

\item{max_results_per_db}{Maximum results per database}
}
\value{
Combined search results from all databases
}
\description{
Search multiple databases and combine results for comprehensive analysis.
}
\examples{
\donttest{
# Define search strategy
strategy <- list(
  terms = "diabetes AND treatment",
  date_range = c("2020/01/01", "2023/12/31"),
  max_results = 50
)

# Search multiple databases
results <- search_multiple_databases(
  search_strategy = strategy,
  databases = c("pubmed"),
  max_results_per_db = 100
)

# Analyze results
analyzer <- SearchAnalyzer$new(results)
metrics <- analyzer$calculate_metrics()
}

}
