% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweetfunctions.R
\name{get.infectiousness}
\alias{get.infectiousness}
\title{Estimate the infectiousness of an information cascade}
\usage{
get.infectiousness(
  share.time,
  degree,
  p.time,
  max.window = 2 * 60 * 60,
  min.window = 300,
  min.count = 5
)
}
\arguments{
\item{share.time}{observed resharing times, sorted, share.time[1] =0}

\item{degree}{observed node degrees}

\item{p.time}{equally spaced vector of time to estimate the infectiousness, p.time[1]=0}

\item{max.window}{maximum span of the locally weight kernel}

\item{min.window}{minimum span of the locally weight kernel}

\item{min.count}{the minimum number of resharings included in the window}
}
\value{
a list of three vectors: \itemize{
\item infectiousness. the estimated infectiousness
\item p.up. the upper 95 percent approximate confidence interval
\item p.low. the lower 95 percent approximate confidence interval
}
}
\description{
Estimate the infectiousness of an information cascade
}
\details{
Use a triangular kernel with shape changing over time. At time p.time, use a triangluer kernel with slope = min(max(1/(\code{p.time}/2), 1/\code{min.window}), \code{max.window}).
}
\examples{
data(tweet)
pred.time <- seq(0, 6 * 60 * 60, by = 60)
infectiousness <- get.infectiousness(tweet[, 1], tweet[, 2], pred.time)
plot(pred.time, infectiousness$infectiousness)
}
