% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{has_name}
\alias{has_name}
\title{Does an element have a tag name?}
\usage{
has_name(x, name)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{name}{A string.}
}
\value{
A boolean value.
}
\description{
Check that an element has a specified tag name
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div id='mydiv'></div>
"
session <- minimal_selenider_session(html)

has_name(s("#mydiv"), "p")

has_name(s("#mydiv"), "div")
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_attr}()},
\code{\link{has_css_property}()},
\code{\link{has_length}()},
\code{\link{has_text}()},
\code{\link{is_enabled}()},
\code{\link{is_present}()},
\code{\link{is_visible}()}
}
\concept{conditions}
