% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv.R
\name{mv}
\alias{mv}
\title{Mean Variance (MV) statistics}
\usage{
mv(x, y, return_mat = FALSE)
}
\arguments{
\item{x}{Data of univariate continuous variables, which should be a vector of
length \eqn{n}.}

\item{y}{Data of categorical variables, which should be a factor of length
\eqn{n}.}

\item{return_mat}{A boolean. If \code{FALSE} (the default), only the calculated
statistic is returned. If \code{TRUE}, also return the matrix of the indicator
for x <= x_i, which is useful for the permutation test.}
}
\value{
The value of the corresponding sample statistic.

If the argument \code{return_mat} of \code{mv()} is set as \code{TRUE}, a list with
elements
\itemize{
\item \code{mv}: the MV index statistic;
\item \code{mat_x}: the matrices of the distances of the indicator for x <= x_i;
}

will be returned.
}
\description{
Compute the statistics of mean variance (MV) index, which can
measure the dependence between a univariate continuous variable and a
categorical variable. See Cui, Li and Zhong (2015); Cui and Zhong (2019)
for details.
}
\examples{
x <- mtcars[, "mpg"]
y <- factor(mtcars[, "am"])
print(mv(x, y))

# Man-made independent data -------------------------------------------------
n <- 30; R <- 5; prob <- rep(1/R, R)
x <- rnorm(n)
y <- factor(sample(1:R, size = n, replace = TRUE, prob = prob), levels = 1:R)
print(mv(x, y))

# Man-made functionally dependent data --------------------------------------
n <- 30; R <- 3
x <- rep(0, n)
x[1:10] <- 0.3; x[11:20] <- 0.2; x[21:30] <- -0.1
y <- factor(rep(1:3, each = 10))
print(mv(x, y))

}
\seealso{
\itemize{
\item \code{\link[=mv_test]{mv_test()}} for implementing independence test via MV index;
\item \code{\link[=mv_sis]{mv_sis()}} for implementing feature screening via MV index.
}
}
