% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semidist.R
\name{sd_sis}
\alias{sd_sis}
\title{Feature screening via semi-distance correlation}
\usage{
sd_sis(X, y, group_info = NULL, d = NULL, parallel = FALSE)
}
\arguments{
\item{X}{Data of multivariate covariates, which should be an
\eqn{n}-by-\eqn{p} matrix.}

\item{y}{Data of categorical response, which should be a factor of length
\eqn{n}.}

\item{group_info}{A list specifying the group information, with elements
being sets of indicies of covariates in a same group. For example,
\code{list(c(1, 2, 3), c(4, 5))} specifies that covariates 1, 2, 3 are in a
group and covariates 4, 5 are in another group.

Defaults to \code{NULL}. If \code{NULL}, then it will be set as \code{list(1, 2, ..., p)},
that is, treat each single covariate as a group.

If \code{X} has colnames, then the colnames can be used to specified the
\code{group_info}. For example, \code{list(c("a", "b"), c("c", "d"))}.

The names of the list can help recoginize the group. For example,
\code{list(grp_ab = c("a", "b"), grp_cd = c("c", "d"))}. If names of the list
are not specified, \code{c("Grp 1", "Grp 2", ..., "Grp J")} will be applied.}

\item{d}{An integer specifying \emph{at least} how many (single) features should
be kept after screening. For example, if \code{group_info = list(c(1, 2), c(3, 4))} and \code{d = 3}, then all features 1, 2, 3, 4 must be selected since it
should guarantee at least 3 features are kept.

Defaults to \code{NULL}. If \code{NULL}, then it will be set as \eqn{[n / log(n)]},
where \eqn{[x]} denotes the integer part of x.}

\item{parallel}{A boolean indicating whether to calculate parallelly via
\code{furrr::future_map}. Defaults to \code{FALSE}.}
}
\value{
A list of the objects about the implemented feature screening:
\itemize{
\item \code{group_info}: group information;
\item \code{measurement}: sample semi-distance correlations calculated for the groups
specified in \code{group_info};
\item \code{selected}: indicies/names of (single) covariates that are selected after
feature screening;
\item \code{ordering}: order of the calculated measurements of the groups specified in
\code{group_info}. The first one is the largest, and the last is the smallest.
}
}
\description{
Implement the (grouped) feature screening for the classification
problem via semi-distance correlation.
}
\examples{
X <- mtcars[, c("mpg", "disp", "hp", "drat", "wt", "qsec")]
y <- factor(mtcars[, "am"])

sd_sis(X, y, d = 4)

# Suppose we have prior information for the group structure as
# ("mpg", "drat"), ("disp", "hp") and ("wt", "qsec")
group_info <- list(
  mpg_drat = c("mpg", "drat"),
  disp_hp = c("disp", "hp"),
  wt_qsec = c("wt", "qsec")
)
sd_sis(X, y, group_info, d = 4)

}
\seealso{
\code{\link[=sdcor]{sdcor()}} for calculating the sample semi-distance correlation.
}
