% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-func.R
\name{Func}
\alias{Func}
\title{Monte Carlo Confidence Intervals (List)}
\usage{
Func(coef, func, ..., est, alpha = c(0.001, 0.01, 0.05), ncores = NULL)
}
\arguments{
\item{coef}{List.
A list of parameters.}

\item{func}{R function.
\enumerate{
\item The first argument \code{x} is the argument \code{coef}.
\item The function algebraically manipulates \code{coef}
to return at a new numeric vector.
It is best to have a named vector as an output.
\item The function can take additional named arguments
passed using \code{...}.
}}

\item{...}{Additional arguments to pass to \code{func}.}

\item{est}{Numeric vector.
Vector of original parameter estimates.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}

\item{ncores}{Positive integer.
Number of cores to use.
If \code{ncores = NULL}, use single core.}
}
\value{
Returns an object of class \code{semmcci} which is
a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{List of function arguments.}
\item{thetahat}{Parameter estimates \eqn{\hat{\theta}}.}
\item{thetahatstar}{Sampling distribution of parameter estimates
\eqn{\hat{\theta}^{\ast}}.}
\item{fun}{Function used ("Func").}
}
}
\description{
Calculates Monte Carlo confidence intervals
for defined parameters.
}
\details{
The distribution of parameters is provided as a list (\code{params})
and the definition of the function of paremeters
is provided by a function (\code{func}).
Confidence intervals for defined parameters
are generated using the generated sampling distribution.
}
\examples{
library(semmcci)

## Generate Parameters -----------------------------------------------------
coef <- lapply(
  X = 1:5,
  FUN = function(i) {
    rnorm(n = 1)
  }
)

## Func() ------------------------------------------------------------------
### Define func ------------------------------------------------------------
func <- function(x) {
  out <- exp(x)
  names(out) <- "exp"
  out
}
### Generate Confidence Intervals ------------------------------------------
Func(
  coef,
  func = func,
  est = 1,
  alpha = 0.05
)

}
\references{
MacKinnon, D. P., Lockwood, C. M., & Williams, J. (2004).
Confidence limits for the indirect effect:
Distribution of the product and resampling methods.
\emph{Multivariate Behavioral Research}, \emph{39}(1), 99-128.
\doi{10.1207/s15327906mbr3901_4}

Pesigan, I. J. A., & Cheung, S. F. (2024).
Monte Carlo confidence intervals for the indirect effect with missing data.
\emph{Behavior Research Methods}.
\doi{10.3758/s13428-023-02114-4}

Preacher, K. J., & Selig, J. P. (2012).
Advantages of Monte Carlo confidence intervals for indirect effects.
\emph{Communication Methods and Measures}, \emph{6}(2), 77–98.
\doi{10.1080/19312458.2012.679848}
}
\seealso{
Other Monte Carlo in Structural Equation Modeling Functions: 
\code{\link{MC}()},
\code{\link{MCFunc}()},
\code{\link{MCGeneric}()},
\code{\link{MCMI}()},
\code{\link{MCStd}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Monte Carlo in Structural Equation Modeling Functions}
\keyword{mc}
\keyword{semmcci}
