% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_se.R
\name{mark_se}
\alias{mark_se}
\title{Add Standard Error Estimates to Parameter Estimates (Edge
Labels)}
\usage{
mark_se(
  semPaths_plot,
  object,
  sep = " ",
  digits = 2L,
  ests = NULL,
  std_type = FALSE
)
}
\arguments{
\item{semPaths_plot}{A qgraph object generated by
\code{\link[semPlot]{semPaths}}, or a similar qgraph object
modified by other \link{semptools} functions.}

\item{object}{The object used by semPaths to generate the plot. Use
the same argument name used in \code{\link[semPlot]{semPaths}} to
make the meaning of this argument obvious. Currently only object
of class \code{lavaan} is supported.}

\item{sep}{A character string to separate the coefficient and the
standard error (in parentheses). Default to " " (one space). Use
\code{"\n"} to enforce a line break.}

\item{digits}{Integer indicating number of decimal places for the
appended standard errors. Default is 2L.}

\item{ests}{A data.frame from the
\code{\link[lavaan]{parameterEstimates}} function, or
from other function with these columns:? \code{lhs}, \code{op},
\code{rhs}, and \code{se}. Only used when
\code{object} is not specified.}

\item{std_type}{If standardized solution is used in the plot,
set this either to the type of standardization (e.g., \code{"std.all"})
or to \code{TRUE}. It will be passed to \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}
to compute the standard errors for the standardized solution.
Used only if standard errors are not supplied directly
through \code{ests}.}
}
\value{
If the input is a \link[qgraph:qgraph]{qgraph::qgraph} object, the function
returns a qgraph based on the original one, with standard error
estimates appended. If the input is a list of qgraph objects, the
function returns a list of the same length.
}
\description{
Add standard error estimates, in parentheses, to
parameter estimates (edge labels) in a \link[qgraph:qgraph]{qgraph::qgraph} object.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\code{\link[semPlot]{semPaths}} (currently in parentheses) to the
labels. Require either the original object used in the semPaths call,
or a data frame with the standard error for each parameter. The latter
option is for standard errors not computed by lavaan but by
other functions.

Currently supports only plots based on \code{\link[lavaan]{lavaan}}
output.

This function is a variant of, and can be combined with,  the
\code{\link{mark_sig}} function.
}
\examples{
mod_pa <-
  'x1 ~~ x2
   x3 ~  x1 + x2
   x4 ~  x1 + x3
  '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[ , c("lhs", "op", "rhs",
                                       "est", "pvalue", "se")]
m <- matrix(c("x1",   NA,   NA,
               NA, "x3", "x4",
             "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels = "est",
                         style = "ram",
                         nCharNodes = 0, nCharEdges = 0,
                         layout = m)
p_pa2 <- mark_se(p_pa, fit_pa)
plot(p_pa2)

mod_cfa <-
 'f1 =~ x01 + x02 + x03
  f2 =~ x04 + x05 + x06 + x07
  f3 =~ x08 + x09 + x10
  f4 =~ x11 + x12 + x13 + x14
 '
fit_cfa <- lavaan::sem(mod_cfa, cfa_example)
lavaan::parameterEstimates(fit_cfa)[ , c("lhs", "op", "rhs",
                                        "est", "pvalue", "se")]
p_cfa <- semPlot::semPaths(fit_cfa, whatLabels = "est",
                          style = "ram",
                          nCharNodes = 0, nCharEdges = 0)
# Place standard errors on a new line
p_cfa2 <- mark_se(p_cfa, fit_cfa, sep = "\n")
plot(p_cfa2)

mod_sem <-
'f1 =~ x01 + x02 + x03
 f2 =~ x04 + x05 + x06 + x07
 f3 =~ x08 + x09 + x10
 f4 =~ x11 + x12 + x13 + x14
 f3 ~  f1 + f2
 f4 ~  f1 + f3
'
fit_sem <- lavaan::sem(mod_sem, sem_example)
lavaan::parameterEstimates(fit_sem)[ , c("lhs", "op", "rhs",
                                        "est", "pvalue", "se")]
p_sem <- semPlot::semPaths(fit_sem, whatLabels = "est",
                          style = "ram",
                          nCharNodes = 0, nCharEdges = 0)
# Mark significance, and then add standard errors
p_sem2 <- mark_sig(p_sem, fit_sem)
p_sem3 <- mark_se(p_sem2, fit_sem, sep = "\n")
plot(p_sem3)

}
