% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-fxns.R
\name{sensibo.pod.smartmode.set}
\alias{sensibo.pod.smartmode.set}
\title{Set the air conditioner (pod) Climate Reactmode. Set to TRUE to enable and FALSE to disable.}
\usage{
sensibo.pod.smartmode.set(pod, enable = NULL,
  key = getOption("sensibo.key"))
}
\arguments{
\item{pod}{(character) Pod unique id. Required: TRUE}

\item{enable}{(logical) Set to TRUE to turn on the climate react, FALSE to turn off instead.}

\item{key}{(character) API key from https://home.sensibo.com/me/api.}
}
\value{
A list with the updated status of Climate React settings change.
}
\description{
Set the air conditioner (pod) Climate Reactmode. Set to TRUE to enable and FALSE to disable.
}
\examples{
\dontrun{
# Assuming that a valid Sensibo Sky API Key was created on https://home.sensibo.com/me/api
# and added to a 'sensibo.sky' global option.
#
# options("sensibo.key" = <Your Sensibo API Key>)
 
## Getting the list of pods available to the user
pods.id <- sensibo.pods()

## Enable the Climate React mode for the first pod
sensibo.pod.smartmode.set(pods.id[1], TRUE)
}
}
