% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_batch_metrics.R
\name{st_batch_metrics}
\alias{st_batch_metrics}
\title{Batch Fetch Metrics for Multiple Apps}
\usage{
st_batch_metrics(
  os,
  app_list,
  metrics = c("revenue", "downloads"),
  date_range = list(start_date = Sys.Date() - 90, end_date = Sys.Date() - 1),
  countries,
  granularity,
  parallel = FALSE,
  cache_dir = NULL,
  verbose = TRUE,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  max_cores = 2,
  max_concurrent_requests = 2,
  retry = TRUE,
  max_retries = 3,
  publisher_ids = NULL
)
}
\arguments{
\item{os}{Character. Required. Operating system: "ios", "android", or "unified".
This determines which platform's data is returned for all apps.}

\item{app_list}{List or data frame containing app information. Can be:
- Character vector of app IDs
- Data frame with columns: app_id, app_name (optional), platform (optional)
- List of lists with app_id and optional metadata}

\item{metrics}{Character vector. Metrics to fetch. Supported values:
- "revenue" - App revenue estimates
- "downloads" - App download estimates
- "dau" - Daily Active Users
- "wau" - Weekly Active Users
- "mau" - Monthly Active Users}

\item{date_range}{List with start_date and end_date, or "ytd" for year-to-date}

\item{countries}{Character vector. Country codes. Required.}

\item{granularity}{Character. Date granularity (default "monthly")}

\item{parallel}{Logical. Use parallel processing (default FALSE)}

\item{cache_dir}{Character. Directory for caching results (optional)}

\item{verbose}{Logical. Show progress messages (default TRUE)}

\item{auth_token}{Character string. Your Sensor Tower API authentication token.}

\item{max_cores}{Integer. Maximum number of cores to use for parallel processing.}

\item{max_concurrent_requests}{Integer. Max concurrent requests (deprecated/unused).}

\item{retry}{Logical. Whether to retry failed requests.}

\item{max_retries}{Integer. Max retries.}

\item{publisher_ids}{Character vector. Publisher IDs to fetch data for.}
}
\value{
A tibble with all metrics for all apps.
}
\description{
Efficiently fetch metrics for multiple apps by batching API calls and
automatically handling platform-specific requirements. The OS parameter
controls which platform's data is returned for all apps.
}
