% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields.R
\name{st_custom_fields_values}
\alias{st_custom_fields_values}
\title{Get Custom Fields Values}
\usage{
st_custom_fields_values(
  term = NULL,
  auth_token = NULL,
  base_url = "https://api.sensortower.com"
)
}
\arguments{
\item{term}{Optional. Character string. Search term to filter field names.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{base_url}{Optional. Character string. The base URL for the API.}
}
\value{
A tibble containing custom fields and their possible values
}
\description{
Retrieves a list of all accessible custom fields and their possible values.
This is useful for discovering what custom fields are available to filter by.
}
\examples{
\dontrun{
# Get all custom fields
fields <- st_custom_fields_values()

# Search for specific fields
date_fields <- st_custom_fields_values(term = "date")
}

}
