% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_publisher_apps.R
\name{st_get_app_names}
\alias{st_get_app_names}
\title{Get App Names from Publisher Apps Result}
\usage{
st_get_app_names(apps_df, include_canonical = TRUE)
}
\arguments{
\item{apps_df}{A tibble returned by `st_publisher_apps()`.}

\item{include_canonical}{Logical. If TRUE, includes mappings for canonical IDs
that were resolved during aggregation. Defaults to TRUE.}
}
\value{
A tibble with columns `unified_app_id` and `app_name` suitable for
  joining with sales data or other API results.
}
\description{
Helper function to create a name lookup table from the result of
`st_publisher_apps()`. This handles canonical ID mapping automatically,
so you can join sales data (which uses canonical IDs) back to app names.
}
\examples{
\dontrun{
# Get apps with canonical ID resolution
apps <- st_publisher_apps("647eb849d9d91f31a54f1792", aggregate_related = TRUE)

# Get name lookup table
name_lookup <- st_get_app_names(apps)

# Use with sales data
sales <- st_unified_sales_report(apps$unified_app_id, ...)
sales_with_names <- sales \%>\%
  left_join(name_lookup, by = "unified_app_id")
}

}
