% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sepkoski}
\alias{sepkoski}
\title{Sepkoski's marine animal genera compendium}
\format{
A \code{data.frame} with 35826 rows and 9 variables:
\describe{
\item{phylum}{A character denoting the phylum of the taxon.}
\item{class}{A character denoting the class of the taxon.}
\item{order}{A character denoting the order of the taxon.}
\item{genus}{A character denoting the genus of the taxon.}
\item{fauna}{A character denoting the great evolutionary fauna type of
the taxon.}
\item{interval_max}{A character denoting the interval of first occurrence.}
\item{interval_min}{A character denoting the interval of last occurrence.}
\item{max_ma}{A numeric denoting the interval age of first occurrence.}
\item{min_ma}{A numeric denoting the interval age of last occurrence.}
}
}
\source{
{Shanan Peter's 'Sepkoski's Online Genus Database':}
\url{http://strata.geology.wisc.edu/jack/}.
}
\usage{
sepkoski
}
\description{
This dataset is a port of \href{https://www.biodiversitylibrary.org/page/27980221#page/113/mode/1up}{Sepkoski's (2002)}
published compendium of fossil marine animal genera.
This version of the dataset was pulled from Shanan Peters' \href{http://strata.geology.wisc.edu/jack/}{online database}. No changes have been made to any
taxonomic names. However, first and last appearance intervals have been
updated to stages from the \href{https://stratigraphy.org/ICSchart/ChronostratChart2022-02.pdf}{International Geological Time Scale 2022}. In
updating interval names, some interpretation was required. The
\link[sepkoski]{interval_table} dataset documents the linked interval names.
}
\section{References}{

Sepkoski, J. J. (2002). A compendium of fossil marine animal genera.
\emph{Bulletins of American Paleontology}, 363, pp. 1--560.
}

\keyword{datasets}
