% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/most_probable_cluster.R
\name{most_probable_cluster}
\alias{most_probable_cluster}
\title{Extract Most Probable Cluster for Each Sequence}
\usage{
most_probable_cluster(x, type = "viterbi", hp = NULL)
}
\arguments{
\item{x}{An object of class \code{mhmm} or \code{mnhmm}.}

\item{type}{A character string specifying the method to use. Either
\code{"viterbi"} (default) or \code{"posterior"}. Former uses the most probable hidden
path to determine the cluster membership for each sequence, while the latter
finds the cluster which has the largest sum of posterior probabilities of
states of that cluster.}

\item{hp}{An output from \code{\link[=hidden_paths]{hidden_paths()}} function. Only used in case of
\code{type = "viterbi"}. If missing, hidden paths will be computed using \code{x}.}
}
\value{
A vector containing the most probable cluster for each sequence.
}
\description{
Extract Most Probable Cluster for Each Sequence
}
