% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sim.seqtest.cor.R
\name{print.sim.seqtest.cor}
\alias{print.sim.seqtest.cor}
\title{Print sim.seqtest}
\usage{
\method{print}{sim.seqtest.cor}(x, ...)
}
\arguments{
\item{x}{\code{sim.seqtest.cor} object.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{sim.seqtest.cor} object
}
\examples{
\dontrun{

#---------------------------------------------
# Determine optimal k and nominal type-II-risk
# H0: rho <= 0.3, H1: rho > 0.3
# alpha = 0.01, beta = 0.05, delta = 0.25

# Step 1: Determine the optimal size of subsamples (k)

sim.obj <- sim.seqtest.cor(rho.sim = 0.3, k = seq(4, 16, by = 1), rho = 0.3,
                           alternative = "greater",
                           delta = 0.25, alpha = 0.05, beta = 0.05,
                           runs = 10000, output = FALSE)

print(sim.obj)

# Step 2: Determine the optimal nominal type-II-risk based on
#         the optimal size of subsamples (k) from step 1

sim.obj <- sim.seqtest.cor(rho.sim = 0.55, k = 16, rho = 0.3,
                           alternative = "greater",
                           delta = 0.25, alpha = 0.05, beta = seq(0.05, 0.15, by = 0.01),
                           runs = 10000, output = FALSE)

print(sim.obj)
}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
\references{
Schneider, B., Rasch, D., Kubinger, K. D., & Yanagida, T. (2015).
A Sequential triangular test of a correlation coefficient's null-hypothesis: 0 \eqn{< \rho \le \rho}0.
\emph{Statistical Papers, 56}, 689-699.
}
\seealso{
\code{\link{sim.seqtest.cor}}, \code{\link{plot.sim.seqtest.cor}}
}

