% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_envelope.R
\name{envelope}
\alias{envelope}
\title{Envelope constructor.}
\usage{
envelope(t, v)
}
\arguments{
\item{t}{Numeric vector, normalized time. Vector of increasing values starting at 0 and ending at 1.}

\item{v}{Numeric vector, same size as t, envelop values v(t).}
}
\value{
An object of class 'envelope'.
}
\description{
Creates a new instance of an 'envelope' object
(https://en.wikipedia.org/wiki/Envelope_(music)).
In this package an envelop is viewed as a curve v(t),
where t is the time and v the value of the envelope.
Time t is normalized between 0 and 1 so that 1 corresponds
to the end of the sound sample the envelope is applied to
(and 0 to its beginning).
The curve is defined by a discrete set of points (t,v) (linear interpolation in between).
}
\examples{
# A triangular envelop
env <- envelope(t=c(0,0.3,1),v=c(0,1,0))
# An ADSR envelope (https://en.wikipedia.org/wiki/Envelope_(music)#ADSR)
env <- envelope(t=c(0,0.1,0.3,0.8,1),v=c(0,1,0.4,0.4,0))
# An envelope that could be used for a 1-octave frequency modulation (from 440 to 220 Hz)
env <- envelope(t=c(0,1),v=c(440,220))
# An envelope that could be used for phase modulation
# (https://en.wikipedia.org/wiki/Phase_modulation)
env <- envelope(t=seq(0,1,0.01),v=(-pi/2)*sin(2*pi*4*seq(0,1,0.01)))
}
