% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getNotes}
\alias{getNotes}
\title{Frequencies-to-notes function}
\usage{
getNotes(frequencies, minOctave = 0, maxOctave = 8, option = "b")
}
\arguments{
\item{frequencies}{numeric vector, frequencies in Hz}

\item{minOctave}{integer, smallest (lowest-pitched) octave}

\item{maxOctave}{integer, largest (highest-pitched) octave}

\item{option}{character, use 'b' or '#' in note names?}
}
\value{
a character vector of notes
}
\description{
Get notes (in
\href{https://en.wikipedia.org/wiki/Scientific_pitch_notation}{scientific pitch notation})
from frequencies. The note with the closest frequency is returned.
}
\examples{
# example code
getNotes(seq(440,10000,100))
getNotes(seq(440,10000,100),maxOctave=10,option='#')
}
