% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seromodel.R
\name{extract_central_estimates}
\alias{extract_central_estimates}
\title{Extracts central estimates from stan_fit object for specified parameter}
\usage{
extract_central_estimates(
  seromodel,
  serosurvey,
  alpha = 0.05,
  par_name = "foi_vector"
)
}
\arguments{
\item{seromodel}{stan_fit object obtained from sampling a model
with \link{fit_seromodel}}

\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{alpha}{1 - alpha indicates the credibility level to be used}

\item{par_name}{String specifying the parameter to be extracted
from \code{seromodel}}
}
\value{
A dataframe with the following columns
\describe{
\item{\code{median}}{Median of the samples computed as the 0.5 quantile}
\item{\code{lower}}{Lower quantile \code{alpha}}
\item{\code{upper}}{Upper quantile \code{1 - alpha}}
}
}
\description{
Extracts central estimates from stan_fit object for specified parameter
}
\examples{
data(veev2012)
seromodel <- fit_seromodel(veev2012, iter = 100)
central_estimates <- extract_central_estimates(
  seromodel,
  veev2012,
  par_name = "foi"
)
}
