% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_related_keywords}
\alias{sst_sa_related_keywords}
\title{Related keywords for a keyword}
\usage{
sst_sa_related_keywords(
  keyword,
  se,
  with_intents = FALSE,
  filters = NULL,
  sort = NULL,
  page = 1,
  size = 100,
  return_method = "list",
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{keyword}{(required) A keyword to search for.}

\item{se}{(required) Search engine alias (db_name) returned by \code{\link{sst_sa_database_info}}.}

\item{with_intents}{(optional) TRUE if keyword intent should be retrieved. This parameter works for g_ua and g_us database only.}

\item{filters}{(optional) A list of filtering options. See API docs for more details.}

\item{sort}{(optional) A field to sort the response. See API docs for more details.}

\item{page}{(optional) Response page number if there are many pages in response.}

\item{size}{(optional) Response page size.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns related keywords for a keyword and their metrics.
}
\description{
Returns a list of semantically related keywords for a given keyword.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/7yidbv07n5q9u-get-related-keywords}{here}.
}

\section{API credits consumption}{
 1 per keyword in response.
}

\examples{
\dontrun{
sst_sa_related_keywords(
  keyword       = 'serpstat',
  se            = 'g_us',
  return_method = 'df'
)$data
}
}
