% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-AsyncJob.R
\name{AsyncJob}
\alias{AsyncJob}
\title{R6 Class representing an AsyncJob}
\description{
R6 Class representing a resource for managing asynchronous jobs.
}
\examples{

## ------------------------------------------------
## Method `AsyncJob$print`
## ------------------------------------------------

\dontrun{
 # x is API response when app is requested
 asyncjob_object <- AsyncJob$new(
   res = x,
   href = x$href,
   auth = auth,
   response = attr(x, "response")
 )
 asyncjob_object$print()
}

## ------------------------------------------------
## Method `AsyncJob$reload`
## ------------------------------------------------

\dontrun{
 # x is API response when AsyncJob is requested
 asyncjob_object <- AsyncJob$new(
   res = x,
   href = x$href,
   auth = auth,
   response = attr(x, "response")
 )
 asyncjob_object$reload()
}
}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{AsyncJob}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Asynchronous job ID.}

\item{\code{type}}{The type of job. Can be one of: COPY, DELETE, MOVE.}

\item{\code{state}}{The following states are available: SUBMITTED, RESOLVING,
RUNNING and FINISHED.}

\item{\code{result}}{The result of the job.}

\item{\code{total_files}}{The total number of files that were processed for
the job.}

\item{\code{completed_files}}{The number of files that were successfully
completed.}

\item{\code{failed_files}}{The number of files that failed.}

\item{\code{started_on}}{The time and date the job started.}

\item{\code{finished_on}}{The time and date the job finished.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AsyncJob-new}{\code{AsyncJob$new()}}
\item \href{#method-AsyncJob-print}{\code{AsyncJob$print()}}
\item \href{#method-AsyncJob-reload}{\code{AsyncJob$reload()}}
\item \href{#method-AsyncJob-clone}{\code{AsyncJob$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncJob-new"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncJob-new}{}}}
\subsection{Method \code{new()}}{
Create a new AsyncJob object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncJob$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing AsyncJob object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{AsyncJob} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncJob-print"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncJob-print}{}}}
\subsection{Method \code{print()}}{
Print method for AsyncJob class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncJob$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when app is requested
 asyncjob_object <- AsyncJob$new(
   res = x,
   href = x$href,
   auth = auth,
   response = attr(x, "response")
 )
 asyncjob_object$print()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncJob-reload"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncJob-reload}{}}}
\subsection{Method \code{reload()}}{
Reloads AsyncJob object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncJob$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{AsyncJob}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when AsyncJob is requested
 asyncjob_object <- AsyncJob$new(
   res = x,
   href = x$href,
   auth = auth,
   response = attr(x, "response")
 )
 asyncjob_object$reload()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AsyncJob-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AsyncJob-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AsyncJob$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
