% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_transform_auto.R
\name{st_transform_auto}
\alias{st_transform_auto}
\title{Toggle between lon/lat and UTM co-ordinates}
\usage{
st_transform_auto(data, check = TRUE, quiet = FALSE)
}
\arguments{
\item{data}{An \code{\link[sf]{sf}} object.}

\item{check}{Should the function check if the chosen UTM zone covers all the
data? If so then a warning is issued if the centroid of any row in the data
is more than 1º outside the area covered by the UTM zone.}

\item{quiet}{if set to \code{TRUE}, messages reporting the values of any
parameters set automatically will be suppressed. The default is
\code{FALSE}.}
}
\value{
SF object transformed to new CRS.
}
\description{
It is often useful to convert geographic data to a projected co-ordinate
system, e.g. for specifying a buffer distance in metres.
\code{st_transform_auto} converts between lon/lat co-ordinates and the UTM
or UPS zone for the centroid of the data.
}
