% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_cartesian_small_multiples.R
\name{draw_cartesian_small_multiples}
\alias{draw_cartesian_small_multiples}
\title{Draw Cartesian Small Multiples Plot}
\usage{
draw_cartesian_small_multiples(
  data,
  x_coord,
  y_coord,
  grouping_var,
  faceting_var_1,
  faceting_var_2,
  interactive = FALSE,
  size = 2,
  alpha = 0.4,
  analysis_desc_label = NULL,
  x_axis_label = NULL,
  y_axis_label = NULL,
  n_breaks_x_axis = 10,
  n_breaks_y_axis = 10,
  accuracy = 0.001,
  show_axis_values = TRUE
)
}
\arguments{
\item{data}{Input dataset to be plotted (required)}

\item{x_coord}{Column for X coordinate values (required)}

\item{y_coord}{Column for Y coordinate values (required)}

\item{grouping_var}{Grouping variable. Each group is displayed in a different color. (optional)}

\item{faceting_var_1}{Set first faceting variable (optional)}

\item{faceting_var_2}{Set second faceting variable (optional)}

\item{interactive}{Set plot interactivity. By default, it is set to FALSE (optional)}

\item{size}{Set point size. By default, it is set to 2  (optional)}

\item{alpha}{Set transparency. By default, it is set to 0.4  (optional)}

\item{analysis_desc_label}{Label (subtitle) for analysis description. By default, it is set to NULL  (optional)}

\item{x_axis_label}{Label for x axis. By default, it is set to display x axis column name  (optional)}

\item{y_axis_label}{Label for y axis. By default, it is set to display y axis column name  (optional)}

\item{n_breaks_x_axis}{Set number of breaks on X axis. By default, it is set to 10 (optional)}

\item{n_breaks_y_axis}{Set number of breaks on Y axis. By default, it is set to 10 (optional)}

\item{accuracy}{Set number of decimal places to be displayed on X and Y axes. Examples: 0.1 - one decimal place, 0.01 - two decimal places, 0.001 - three decimal places etc. By default, it is set to 0.001 (optional)}

\item{show_axis_values}{Logical. if FALSE, default, axis values are not shown (optional)}
}
\value{
A 'ggplot' or 'plotly' object
}
\description{
Draws a cartesian small multiples plot
}
