% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Label}
\alias{Label}
\title{Label}
\usage{
Label(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Labels give a name or title to a control or group of controls, including text fields, check boxes, combo boxes, radio buttons, and drop-down menus.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Label}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item \bold{ as } \verb{IComponentAs<React.AllHTMLAttributes<HTMLElement>>} \cr Render the root element as another type.
\item \bold{ componentRef } \verb{IRefObject<ILabel>} \cr Optional callback to access the ILabel interface. Use this instead of ref for accessing the public methods and properties of the component.
\item \bold{ disabled } \code{boolean} \cr Renders the label as disabled.
\item \bold{ required } \code{boolean} \cr Whether the associated form field is required or not
\item \bold{ styles } \verb{IStyleFunctionOrObject<ILabelStyleProps, ILabelStyles>} \cr Styles for the label.
\item \bold{ theme } \code{ITheme} \cr Theme provided by HOC.
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Labels should be close to the control they're paired with.
}
}

\subsection{Content}{
\itemize{
\item Labels should describe the purpose of the control.
\item Use sentence-style capitalization—only capitalize the first word. For more info, see \href{https://docs.microsoft.com/style-guide/capitalization}{Capitalization} in the Microsoft Writing Style Guide.
\item Be short and concise.
\item Use nouns or short noun phrases.
\item Don't use labels as instructional text. For example, "Click to get started".
}
}
}

\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  Label("Required label", required = TRUE)
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {})
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
