% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_setSpeed.R
\name{lottie_setSpeed}
\alias{lottie_setSpeed}
\title{Adjust 'Lottie' Animation Speed}
\usage{
lottie_setSpeed(
  speed = 1,
  name = "all",
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{speed}{A numeric specifying the desired animation speed.}

\item{name}{A character string specifying the name of the 'Lottie' animation to control.
The default of "\code{all}" will control all animations within the 'shiny' application.}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
This function is called for a side effect, and so there is no return value.
}
\description{
Adjust the speed of an existing 'Lottie' animation.
}
\details{
Sends a custom session message \code{"lottie_js_setSpeed"} containing the function arguments.
}
\note{
A speed of 1 will apply the default animation speed. Use a value between 0 and 1 for a slower animation speed.
Applying a negative speed will also reverse the playback direction.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  ),
  numericInput("speed", "Speed", value = 1),
  actionButton("updateSpeed", "Update Speed")
)

server <- function(input, output, session) {
  observeEvent(input$updateSpeed, {
    lottie_setSpeed(speed = input$speed, name = "my_animation")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{lottie_animation_methods}} for similar methods.
}
