% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Page.R
\name{f7TabLayout}
\alias{f7TabLayout}
\title{Framework7 tab layout}
\usage{
f7TabLayout(..., navbar, messagebar = NULL, panels = NULL)
}
\arguments{
\item{...}{Slot for \link{f7Tabs}.}

\item{navbar}{Slot for \link{f7Navbar}.}

\item{messagebar}{Slot for \link{f7MessageBar}.}

\item{panels}{Slot for \link{f7Panel}.
Wrap in \code{tagList} if multiple panels.}
}
\description{
\code{f7TabLayout} create a single page app with multiple tabs,
giving the illusion of a multi pages experience.
}
\examples{
library(shiny)
library(shinyMobile)
library(apexcharter)
library(shinyWidgets)

poll <- data.frame(
  answer = c("Yes", "No"),
  n = c(254, 238)
)

app <- shinyApp(
  ui = f7Page(
    title = "Tabs layout",
    f7TabLayout(
      panels = tagList(
        f7Panel(title = "Left Panel", side = "left", "Blabla", effect = "cover"),
        f7Panel(title = "Right Panel", side = "right", "Blabla", effect = "cover")
      ),
      navbar = f7Navbar(
        title = "Tabs",
        leftPanel = TRUE,
        rightPanel = TRUE
      ),
      f7Tabs(
        animated = TRUE,
        # swipeable = TRUE,
        f7Tab(
          title = "Tab 1",
          tabName = "Tab1",
          icon = f7Icon("folder"),
          active = TRUE,
          f7List(
            strong = TRUE,
            prettyRadioButtons(
              inputId = "theme",
              label = "Select a theme:",
              thick = TRUE,
              inline = TRUE,
              selected = "md",
              choices = c("ios", "md"),
              animation = "pulse",
              status = "info"
            ),
            prettyRadioButtons(
              inputId = "dark",
              label = "Select a color:",
              thick = TRUE,
              inline = TRUE,
              selected = "dark",
              choices = c("light", "dark"),
              animation = "pulse",
              status = "info"
            )
          ),
          f7Card(
            title = "Card header",
            apexchartOutput("pie")
          )
        ),
        f7Tab(
          title = "Tab 2",
          tabName = "Tab2",
          icon = f7Icon("keyboard"),
          f7Card(
            title = "Card header",
            apexchartOutput("scatter")
          )
        ),
        f7Tab(
          title = "Tab 3",
          tabName = "Tab3",
          icon = f7Icon("layers_alt"),
          f7Card(
            title = "Card header",
            f7SmartSelect(
              "variable",
              "Variables to show:",
              c(
                "Cylinders" = "cyl",
                "Transmission" = "am",
                "Gears" = "gear"
              ),
              openIn = "sheet",
              multiple = TRUE
            ),
            tableOutput("data")
          )
        )
      )
    )
  ),
  server = function(input, output, session) {
    # river plot
    dates <- reactive(seq.Date(Sys.Date() - 30, Sys.Date(), by = input$by))

    output$pie <- renderApexchart({
      apex(
        data = poll,
        type = "pie",
        mapping = aes(x = answer, y = n)
      )
    })

    output$scatter <- renderApexchart({
      apex(
        data = mtcars,
        type = "scatter",
        mapping = aes(
          x = wt,
          y = mpg,
          fill = cyl
        )
      )
    })


    # datatable
    output$data <- renderTable(
      {
        mtcars[, c("mpg", input$variable), drop = FALSE]
      },
      rownames = TRUE
    )


    # theme changes
    observe({
      updateF7App(
        options =list(
          theme = input$theme,
          dark = ifelse(input$dark == "dark", TRUE, FALSE)
        )
      )
    })

  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
