% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/human.R
\name{human}
\alias{human}
\title{Interactive Human Body Widget}
\usage{
human(
  gender = c("male", "female"),
  organ_df,
  select_color = "yellow",
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{gender}{One of "male" or "female"}

\item{organ_df}{A data.frame with at least an \code{organ} column, and optionally
the following columns:
\itemize{
\item \code{show}: A logical (Boolean) column indicating whether or not each organ
should be visible. If absent, all organs will be shown.
\item \code{selected}: A logical (Boolean) column indicating whether or not each
organ should be in a "selected" state. If absent, no organs will be selected.
\item \code{hovertext}: A character column or a column containing \code{shiny.tag}
objects. This will be the contents of the tooltip that appears when the organ
is hovered over. If absent, the tooltip will contain the title-cased name of
the organ (underscores replaced with spaces).
\item \code{color}: A character column indicating the color of the organ. If absent,
all organs will be shown in black.
If \code{organ_df} has other columns, these will be ignored.
}}

\item{select_color}{The color that should be applied to organs with the
"selected" state (activated by clicking the organ and deactivated by clicking
again).}

\item{width}{Widget width}

\item{height}{Widget height}

\item{elementId}{ID of the widget}
}
\value{
An object of class \code{human} and class \code{htmlwidget}.
}
\description{
This widget visualizes an SVG-based human body, highlights specific body
parts, and displays associated participant data.
}
\examples{
example_organs <- c("brain", "eye", "heart", "stomach", "bladder")
my_organ_df <- subset(shinybody_organs, organ \%in\% example_organs)
my_organ_df$show <- TRUE
my_organ_df$color <- grDevices::rainbow(nrow(my_organ_df))
my_organ_df$selected[1] <- TRUE
my_organ_df$hovertext <- mapply(
  function(o, clr) htmltools::strong(
    tools::toTitleCase(o),
    style = paste("color:", clr)
  ),
  my_organ_df$organ,
  my_organ_df$color,
  SIMPLIFY = FALSE
)
human(gender = "female", organ_df = my_organ_df)
}
