% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_device}
\alias{get_device}
\title{Get user's device (mobile or desktop)}
\usage{
get_device()
}
\value{
User's detected decive type ("Mobile" or "Desktop")
}
\description{
The value is reactive, therefore it must be accessed inside a reactive context
(such as an \link[shiny:observe]{observe} or \link[shiny:reactive]{reactive}).\cr\cr
\{shinybrowser\} must be initialized with a call to \code{\link[=detect]{detect()}} in the app's ui.
}
\section{Accuracy}{

It's important to understand there is no reliable way to detect the
information in \{shinybrowser\} with 100\% accuracy.\cr\cr\{shinybrowser\} makes
a best effort at identifying the most accurate information, but some
browser/operating system combinations may be difficult to identify. Users
can also use a variety of tools to deliberately spoof this information.\cr\cr
With that in mind, \{shinybrowser\} should detect the correct information in
most cases.
}

\section{Mobile vs desktop vs tablet}{

\{shinybrowser\} attempts to detect whether a device is "mobile" or "desktop".
The distinction between mobile and desktop is not always clear, so if what you
actually care about is the size of the device, it might be better to use
\code{\link[=get_width]{get_width()}}.\cr\cr
Tablets return ambiguous results; some tablets self-report as mobile devices while
others as desktop.
}

\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Your device:",
    textOutput("device_info")
  )
  server <- function(input, output, session) {
    output$device_info <- renderText({
      shinybrowser::get_device()
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=detect]{detect()}}, \code{\link[=get_all_info]{get_all_info()}}, \code{\link[=is_device_mobile]{is_device_mobile()}}, \code{\link[=is_device_desktop]{is_device_desktop()}},
\code{\link[=get_width]{get_width()}}, \code{\link[=get_height]{get_height()}}
}
