% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardHeader.R
\name{dropdownMenu}
\alias{dropdownMenu}
\title{Create a dropdown menu to place in a dashboard header}
\usage{
dropdownMenu(
  ...,
  type = c("messages", "notifications", "tasks"),
  badgeStatus = "primary",
  icon = NULL,
  headerText = NULL,
  .list = NULL
)
}
\arguments{
\item{...}{Items to put in the menu. Typically, message menus should contain
\code{\link[=messageItem]{messageItem()}}s, notification menus should contain
\code{\link[=notificationItem]{notificationItem()}}s, and task menus should contain
\code{\link[=taskItem]{taskItem()}}s.}

\item{type}{The type of menu. Should be one of "messages", "notifications",
"tasks".}

\item{badgeStatus}{The status of the badge which displays the number of items
in the menu. This determines the badge's color. Valid statuses are listed
in \link{validStatuses}. A value of \code{NULL} means to not display a
badge.}

\item{icon}{An icon to display in the header. By default, the icon is
automatically selected depending on \code{type}, but it can be overriden
with this argument.}

\item{headerText}{An optional text argument used for the header of the
dropdown menu (this is only visible when the menu is expanded). If none is
provided by the user, the default is "You have \code{x} messages," where
\code{x} is the number of items in the menu (if the \code{type} is
specified to be "notifications" or "tasks," the default text shows "You
have \code{x} notifications" or  "You have \code{x} tasks," respectively).}

\item{.list}{An optional list containing items to put in the menu Same as the
\code{...} arguments, but in list format. This can be useful when working
with programmatically generated items.}
}
\description{
Create a dropdown menu to place in a dashboard header
}
\seealso{
\code{\link[=dashboardHeader]{dashboardHeader()}} for example usage.
}
